/*
 * Decompiled with CFR 0.152.
 */
package br.com.benevix.sender2.client.util;

import br.com.benevix.sender2.client.enums.AmbienteSistemaEnum;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmbienteUtil {
    private static final Logger LOGGER = Logger.getLogger(AmbienteUtil.class.getName());
    private static final String URL_WEB_SERVICE_SENDER2 = "URL_WEB_SERVICE_SENDER2";
    private static final String EMAIL_DESTINATARIO_TESTE = "EMAIL_DESTINATARIO_TESTE";
    private static final String TELEFONE_TESTE = "TELEFONE_TESTE";
    private static final String BK_AMBIENTE = "BK_AMBIENTE";
    private static final String EMAIL_REMETENTE_DEFAULT = "EMAIL_REMETENTE_DEFAULT";

    private AmbienteUtil() {
    }

    public static String getAmbiente() {
        String ambiente = System.getenv(BK_AMBIENTE);
        if (ambiente == null) {
            ambiente = AmbienteSistemaEnum.DEV.toString();
            LOGGER.log(Level.FINE, "Propriedade de AMBIENTE n\u00e3o encontrada, ser\u00e1 utilizada o ambiente default: {0}", ambiente);
        }
        LOGGER.log(Level.FINEST, "AMBIENTE Atual: {0}", ambiente);
        return ambiente;
    }

    public static String getEmpresa() {
        String empresa = System.getenv("EMPRESA");
        if (empresa == null) {
            empresa = "BENEVIX";
        }
        LOGGER.log(Level.FINEST, "EMPRESA Atual: {0}", empresa);
        return empresa.toLowerCase();
    }

    public static boolean isAmbienteProducao() {
        return AmbienteSistemaEnum.PRD.toString().equals(AmbienteUtil.getAmbiente());
    }

    private static ResourceBundle getPropriedadesAmbiente() {
        return ResourceBundle.getBundle("br.com." + AmbienteUtil.getEmpresa() + ".sender.client.ambiente.custom." + AmbienteUtil.getAmbiente());
    }

    public static String getUrlEndpointSender2() {
        return AmbienteUtil.getPropriedadesAmbiente().getString(URL_WEB_SERVICE_SENDER2);
    }

    public static String getEmailDestinatarioTeste() {
        return AmbienteUtil.getPropriedadesAmbiente().getString(EMAIL_DESTINATARIO_TESTE);
    }

    public static String getTelefoneTeste() {
        return AmbienteUtil.getPropriedadesAmbiente().getString(TELEFONE_TESTE);
    }

    public static String getEmailRemetenteDefault() {
        return AmbienteUtil.getPropriedadesAmbiente().getString(EMAIL_REMETENTE_DEFAULT);
    }
}

