/*
 * Decompiled with CFR 0.152.
 */
package br.com.benevix.sender2.client;

import br.com.benevix.sender2.client.pojo.EmailRequest;
import br.com.benevix.sender2.client.pojo.Login;
import br.com.benevix.sender2.client.pojo.Result;
import br.com.benevix.sender2.client.pojo.SmsRequest;
import br.com.benevix.sender2.client.util.AmbienteUtil;
import br.com.benevix.sender2.client.util.Sender2Utils;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Sender2Service {
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String APPLICATION_JSON = "application/json";
    private static final Logger LOGGER = Logger.getLogger(Sender2Service.class.getName());

    public Result enviarEmail(EmailRequest emailRequest) throws Exception {
        LOGGER.log(Level.INFO, "Enviando email!");
        Result result = null;
        if (Sender2Utils.isEmptyOrNull(emailRequest.getRemetente())) {
            emailRequest.setRemetente(AmbienteUtil.getEmailRemetenteDefault());
        }
        if (!AmbienteUtil.isAmbienteProducao()) {
            emailRequest.setDestinatarios(Arrays.asList(AmbienteUtil.getEmailDestinatarioTeste()));
            emailRequest.setAssunto("[AMBIENTE " + AmbienteUtil.getAmbiente() + "] - " + emailRequest.getAssunto());
        }
        emailRequest.setCorpo(Sender2Utils.escapeHtml(emailRequest.getCorpo()));
        try {
            result = this.callPostAuthenticated("email/enviar", emailRequest, Result.class);
            if (result != null) {
                if (result.isSuccess()) {
                    LOGGER.info("Email enviado com sucesso!");
                } else {
                    LOGGER.info("Erro ao enviar o email: " + result.getErrorMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Erro ao enviar o email: " + e.getMessage(), e);
            throw new Exception(e);
        }
        return result;
    }

    public Result enviarSMS(SmsRequest smsRequest) throws Exception {
        Result result = null;
        LOGGER.log(Level.INFO, "Enviando SMS!");
        if (!AmbienteUtil.isAmbienteProducao()) {
            smsRequest.setTelefone(AmbienteUtil.getTelefoneTeste());
        }
        try {
            result = this.callPostAuthenticated("sms/enviar", smsRequest, Result.class);
            if (result != null) {
                if (result.isSuccess()) {
                    LOGGER.info("SMS enviado com sucesso!");
                } else {
                    LOGGER.info("Erro ao enviar o SMS: " + result.getErrorMessage());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Erro ao enviar o SMS: " + ex.getMessage(), ex);
            throw new Exception(ex);
        }
        return result;
    }

    private String getToken() {
        String token = "";
        try {
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.MINUTES).writeTimeout(10L, TimeUnit.MINUTES).readTimeout(10L, TimeUnit.MINUTES).build();
            MediaType mediaType = MediaType.parse((String)APPLICATION_JSON);
            Gson gson = new Gson();
            String json = gson.toJson((Object)new Login(new String(Base64.getDecoder().decode("c2VuZGVydXNlcg==")), new String(Base64.getDecoder().decode("MDBlNGFjOTU1MGJkNDk3MDM0ZjYyM2FjNDU0ZmZiNjczMDBiNDE4Yw=="))));
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request = new Request.Builder().url(AmbienteUtil.getUrlEndpointSender2() + "login").post(body).addHeader("Content-Type", APPLICATION_JSON).addHeader("cache-control", "no-cache").build();
            Response response = client.newCall(request).execute();
            token = response.header(HEADER_AUTHORIZATION);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Erro ao realizar login no Sender2", ex);
        }
        return token;
    }

    public boolean endpointIsActive() {
        boolean active = false;
        try {
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.MINUTES).writeTimeout(10L, TimeUnit.MINUTES).readTimeout(10L, TimeUnit.MINUTES).build();
            Request request = new Request.Builder().url(AmbienteUtil.getUrlEndpointSender2() + "actuator/health").get().addHeader("Content-Type", APPLICATION_JSON).addHeader("cache-control", "no-cache").build();
            Response response = client.newCall(request).execute();
            active = response.isSuccessful();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Erro ao realizar healthcheck no Sender2", ex);
        }
        return active;
    }

    private <T> T callPostAuthenticated(String path, Object bodyClass, Class<T> responseType) {
        try {
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.MINUTES).writeTimeout(10L, TimeUnit.MINUTES).readTimeout(10L, TimeUnit.MINUTES).build();
            MediaType mediaType = MediaType.parse((String)APPLICATION_JSON);
            Gson gson = new Gson();
            String json = gson.toJson(bodyClass);
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request = new Request.Builder().url(AmbienteUtil.getUrlEndpointSender2() + path).post(body).addHeader("Content-Type", APPLICATION_JSON).addHeader("cache-control", "no-cache").addHeader(HEADER_AUTHORIZATION, this.getToken()).build();
            Response response = client.newCall(request).execute();
            return (T)gson.fromJson(response.body().string(), responseType);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Erro ao executar chamada REST", ex);
            return null;
        }
    }
}

