/*
 * Decompiled with CFR 0.152.
 */
package br.com.benevix.weblib.sistema;

import br.com.benevix.weblib.sistema.ErroException;
import br.com.benevix.weblib.sistema.RetornoErro;
import br.com.benevix.weblib.utilidades.ProcessaJSon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class WebService
extends HttpServlet {
    protected abstract String executarAcao(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ArrayList<RetornoErro> erros = new ArrayList<RetornoErro>();
        String msgErro = "";
        String pagina = "";
        ProcessaJSon pJson = new ProcessaJSon();
        try {
            pagina = this.executarAcao(request, response);
        }
        catch (ErroException e) {
            while (e != null) {
                msgErro = msgErro + e.getMessage() + "\n";
                e = (ErroException)e.getNextException();
            }
        }
        catch (Exception e) {
            erros.add(new RetornoErro(e.getMessage()));
        }
        finally {
            if (msgErro.length() == 0) {
                if (!pagina.equals("")) {
                    response.sendRedirect(pagina);
                }
            } else if (!pagina.equals("")) {
                ErroException.gerarServletException(erros);
            } else {
                erros.add(new RetornoErro(msgErro));
                response.getWriter().println(pJson.toJSON(erros));
            }
            response.getWriter().close();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (ServletException e) {
            Logger.getLogger("WebService - Benevixlib", "Erro ao executar esta classe " + e.getMessage());
        }
        catch (Exception e) {
            Logger.getLogger("WebService - Benevixlib", "Erro ao executar esta classe " + e.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (ServletException e) {
            Logger.getLogger("WebService - Benevixlib", "Erro ao executar esta classe " + e.getMessage());
        }
        catch (Exception e) {
            Logger.getLogger("WebService - Benevixlib", "Erro ao executar esta classe " + e.getMessage());
        }
    }

    public static byte getByte(HttpServletRequest request, String requisicao) {
        try {
            return Byte.parseByte(request.getParameter(requisicao));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static long getLong(HttpServletRequest request, String requisicao) {
        try {
            return Long.parseLong(request.getParameter(requisicao));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static int getInt(HttpServletRequest request, String requisicao) {
        try {
            return Integer.parseInt(request.getParameter(requisicao));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static float getFloat(HttpServletRequest request, String requisicao) {
        try {
            return Float.parseFloat(request.getParameter(requisicao));
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }
}

