/*
 * Decompiled with CFR 0.152.
 */
package br.com.benevix.weblib.persistencia;

import br.com.benevix.weblib.persistencia.Campo;
import br.com.benevix.weblib.persistencia.Conexao;
import br.com.benevix.weblib.persistencia.GeraSql;
import br.com.benevix.weblib.sistema.ErroException;
import br.com.benevix.weblib.sistema.ReciveController;
import br.com.benevix.weblib.utilidades.ProcessaJSon;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public abstract class MovimentoBancoAbastract
extends ProcessaJSon {
    private static Conexao banco = Conexao.getInstance();
    private static String tabela = "";
    private static String view = "";
    private static String relatorio = "";
    private static String inicioTabela = "";
    private static String sql = "";
    private static List<String> erros = new ArrayList<String>();

    public abstract List<Campo> mapaCampos();

    public abstract void setaParametros();

    public abstract String find(List<Campo> var1) throws ErroException;

    public abstract boolean validaDados(List<Campo> var1) throws ErroException;

    public int inserir(HttpServletRequest request, List<Campo> excluirCampos) throws ErroException, SQLException, IOException {
        this.setaParametros();
        List<Campo> parametros = ReciveController.voltaParametrosTela(request, MovimentoBancoAbastract.getInicioTabela(), this.mapaCampos(), excluirCampos);
        if (!this.validaDados(parametros)) {
            throw new ErroException(this.processaErros());
        }
        MovimentoBancoAbastract.setSql(GeraSql.retornaInsert(MovimentoBancoAbastract.getTabela(), parametros, MovimentoBancoAbastract.getInicioTabela(), MovimentoBancoAbastract.getBanco().getDatabase()));
        MovimentoBancoAbastract.getBanco().executa(MovimentoBancoAbastract.getSql());
        return GeraSql.getCodGerado();
    }

    public void alterar(HttpServletRequest request, List<Campo> condicao, List<Campo> excluirCampos) throws ErroException, SQLException, IOException {
        this.setaParametros();
        List<Campo> parametros = ReciveController.voltaParametrosTela(request, MovimentoBancoAbastract.getInicioTabela(), this.mapaCampos(), excluirCampos);
        if (!this.validaDados(parametros)) {
            throw new ErroException(this.processaErros());
        }
        MovimentoBancoAbastract.setSql(GeraSql.retornaUpdate(MovimentoBancoAbastract.getTabela(), parametros, condicao, MovimentoBancoAbastract.getInicioTabela()));
        MovimentoBancoAbastract.getBanco().executa(MovimentoBancoAbastract.getSql());
    }

    public String processaErros() {
        StringBuilder mensagem = new StringBuilder();
        for (int i = 0; i < MovimentoBancoAbastract.getErros().size(); ++i) {
            mensagem.append("<p>" + MovimentoBancoAbastract.getErros().get(i) + "</p>");
        }
        return mensagem.toString();
    }

    public void excluir(List<Campo> condicao) throws ErroException, SQLException, IOException {
        this.setaParametros();
        if (condicao.isEmpty()) {
            throw new ErroException("Voc\u00ea n\u00e3o informou nenuma condi\u00e7\u00e3o de exclus\u00e3o!");
        }
        MovimentoBancoAbastract.setSql(GeraSql.retornaDelete(MovimentoBancoAbastract.getTabela(), condicao, MovimentoBancoAbastract.getInicioTabela()));
        MovimentoBancoAbastract.getBanco().executa(MovimentoBancoAbastract.getSql());
    }

    public static String getTabela() {
        return tabela;
    }

    public static void setTabela(String aTabela) {
        tabela = aTabela;
    }

    public static String getView() {
        return view;
    }

    public static void setView(String aView) {
        view = aView;
    }

    public static String getInicioTabela() {
        return inicioTabela;
    }

    public static void setInicioTabela(String aInicioTabela) {
        inicioTabela = aInicioTabela;
    }

    public static String getSql() {
        return sql;
    }

    public static void setSql(String aSql) {
        sql = aSql;
    }

    public static Conexao getBanco() {
        return banco;
    }

    public static List<String> getErros() {
        return erros;
    }

    public static void setErros(List<String> aErros) {
        erros = aErros;
    }

    public static void iniErros() {
        erros = new ArrayList<String>();
    }

    public static String getRelatorio() {
        return relatorio;
    }

    public static void setRelatorio(String aRelatorio) {
        relatorio = aRelatorio;
    }
}

