/*
 * Decompiled with CFR 0.152.
 */
package br.com.benevix.weblib.persistencia;

import br.com.benevix.weblib.enuns.TipoCampoEnum;
import br.com.benevix.weblib.persistencia.Campo;
import br.com.benevix.weblib.persistencia.Conexao;
import br.com.benevix.weblib.sistema.ErroException;
import br.com.benevix.weblib.utilidades.TrataData;
import br.com.benevix.weblib.utilidades.UtilSistema;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.List;

public class GeraSql {
    private static String sql = "";
    private static String where;
    private static String dataBase;
    private static StringBuilder orderby;
    private static final String TEXTOWHERE = " WHERE ";
    private static final String TEXTOLIKE = " LIKE ";
    private static final String TEXTOPERCENT = "%";
    private static int codGerado;

    private GeraSql() {
    }

    public static String geraSQLSelect(String tabela, List<Campo> parametros, String inicial, List<Campo> orderBy) {
        orderby = new StringBuilder();
        sql = "SELECT * FROM " + tabela;
        if (!parametros.isEmpty()) {
            sql = sql + TEXTOWHERE;
            where = GeraSql.geraWhere(parametros, inicial);
            sql = sql + where;
        }
        if (!orderBy.isEmpty()) {
            orderby.append(" ORDER BY ");
            GeraSql.geraOrderBy(orderBy);
            sql = sql + orderby;
        }
        return sql;
    }

    public static String retornaSelectSimple(String tabela) {
        sql = "SELECT * FROM " + tabela;
        return sql;
    }

    private static String geraOrderBy(List<Campo> orderBy) {
        for (int i = 0; i < orderBy.size(); ++i) {
            if (i == 0) {
                orderby.append(orderBy.get(i).getNomeCampo());
                continue;
            }
            orderby.append("," + orderBy.get(i).getNomeCampo());
        }
        return orderby.toString();
    }

    public static String retornaInsert(String tabela, List<Campo> parametros, String inicial, String base) throws ErroException, IOException {
        int indice = 0;
        dataBase = base;
        StringBuilder campos = new StringBuilder();
        StringBuilder valores = new StringBuilder();
        do {
            if (indice == 0) {
                campos.append(inicial + parametros.get(indice).getNomeCampo());
            } else {
                campos.append("," + inicial + parametros.get(indice).getNomeCampo());
                valores.append(" ,");
            }
            String valorCampo = parametros.get(indice).getValorCampo().trim();
            int tipoCampo = parametros.get(indice).getTipocampo();
            if (tipoCampo == TipoCampoEnum.GERACODIGO.getValor()) {
                GeraSql.setCodGerado(Integer.parseInt(GeraSql.geraCodigo(tabela, parametros.get(indice).getNomeCampo(), inicial)));
                valores.append(GeraSql.getCodGerado());
            }
            if (tipoCampo >= TipoCampoEnum.ALFANUMERICO.getValor() && tipoCampo <= TipoCampoEnum.ALFANUMERICO.getValor()) {
                valores.append("'" + UtilSistema.trataTextAreaTOBanco(valorCampo) + "' ");
            }
            if (tipoCampo >= TipoCampoEnum.PADRAO.getValor()) {
                valores.append("'" + UtilSistema.trataTextAreaTOBanco(valorCampo) + "' ");
            }
            if (tipoCampo >= TipoCampoEnum.INTEIRO.getValor() && tipoCampo <= TipoCampoEnum.BOOLEAN.getValor()) {
                if (valorCampo.isEmpty()) {
                    valores.append("0");
                } else {
                    valores.append(valorCampo);
                }
            }
            if (tipoCampo == TipoCampoEnum.DATE.getValor()) {
                if (parametros.get(indice).getValorCampo().trim().isEmpty()) {
                    valores.append("null");
                } else {
                    valores.append("'" + TrataData.usdata(valorCampo, false) + "' ");
                }
            }
            if (tipoCampo != TipoCampoEnum.DATETIME.getValor()) continue;
            if (parametros.get(indice).getValorCampo().trim().isEmpty()) {
                valores.append("null");
                continue;
            }
            valores.append("'" + TrataData.usdata(valorCampo, true) + "' ");
        } while (++indice < parametros.size());
        sql = "INSERT INTO " + tabela + "(" + campos + ") VALUES(" + valores + ")";
        return sql;
    }

    public static String retornaUpdate(String tabela, List<Campo> parametros, List<Campo> condicao, String inicial) {
        StringBuilder campos = new StringBuilder();
        sql = "UPDATE " + tabela + " SET ";
        for (int i = 0; i < parametros.size(); ++i) {
            if (i > 0 && parametros.get(i).getTipocampo() != 0) {
                campos.append(" ,");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.INTEIRO.getValor()) {
                campos.append(inicial + parametros.get(i).getNomeCampo() + "= " + parametros.get(i).getValorCampo() + " ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.ALFANUMERICO.getValor()) {
                campos.append(inicial + parametros.get(i).getNomeCampo() + " ='" + parametros.get(i).getValorCampo() + "'");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.TEXTAREA.getValor()) {
                campos.append(inicial + parametros.get(i).getNomeCampo() + " ='" + UtilSistema.trataTextAreaTOBanco(parametros.get(i).getValorCampo().trim()) + "' ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.TEXTAREA.getValor()) {
                campos.append(inicial + parametros.get(i).getNomeCampo() + "= " + parametros.get(i).getValorCampo() + " ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.BOOLEAN.getValor()) {
                campos.append(inicial + parametros.get(i).getNomeCampo() + "= " + parametros.get(i).getValorCampo() + " ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.DECIMAL.getValor()) {
                campos.append(inicial + parametros.get(i).getNomeCampo() + "= " + parametros.get(i).getValorCampo() + " ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.GERACODIGO.getValor()) {
                campos.append(inicial + parametros.get(i).getNomeCampo() + "= " + parametros.get(i).getValorCampo() + " ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.DATE.getValor()) {
                campos.append(inicial + parametros.get(i).getNomeCampo() + "='" + TrataData.usdata(parametros.get(i).getValorCampo(), true) + "' ");
            }
            if (parametros.get(i).getTipocampo() != TipoCampoEnum.DATETIME.getValor()) continue;
            campos.append(inicial + parametros.get(i).getNomeCampo() + "='" + TrataData.usdata(parametros.get(i).getValorCampo(), false) + "' ");
        }
        where = GeraSql.geraWhere(condicao, inicial);
        sql = sql + campos + TEXTOWHERE + where;
        return sql;
    }

    public static String retornaDelete(String tabela, List<Campo> parametros, String inicial) {
        sql = "DELETE  FROM " + tabela + TEXTOWHERE;
        where = "";
        where = GeraSql.geraWhere(parametros, inicial);
        sql = sql + where;
        return sql;
    }

    private static String geraWhere(List<Campo> parametros, String inicial) {
        StringBuilder where = new StringBuilder();
        for (int i = 0; i < parametros.size(); ++i) {
            if (i > 0) {
                where.append(" AND ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.ALFANUMERICO.getValor()) {
                String dados = parametros.get(i).getValorCampo();
                if (dados.length() == 0) {
                    where.append(inicial + parametros.get(i).getNomeCampo() + " " + TEXTOLIKE + " '" + TEXTOPERCENT + parametros.get(i).getValorCampo() + TEXTOPERCENT + "'");
                } else {
                    where.append("(");
                    for (int x = 0; x < dados.length(); ++x) {
                        if (x == 0) {
                            where.append(inicial + parametros.get(i).getNomeCampo() + " " + TEXTOLIKE + " '" + TEXTOPERCENT + dados + TEXTOPERCENT + "'");
                            continue;
                        }
                        where.append(" OR " + inicial + parametros.get(i).getNomeCampo() + " " + TEXTOLIKE + " '" + TEXTOPERCENT + dados + TEXTOPERCENT + "'");
                    }
                    where.append(")");
                }
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.INTEIRO.getValor()) {
                where.append(inicial + parametros.get(i).getNomeCampo() + "= ");
                where.append(parametros.get(i).getValorCampo() + " ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.CHAR.getValor()) {
                where.append(inicial + parametros.get(i).getNomeCampo() + "= '");
                where.append(parametros.get(i).getValorCampo() + "' ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.BOOLEAN.getValor()) {
                where.append(inicial + parametros.get(i).getNomeCampo() + "= " + parametros.get(i).getValorCampo() + " ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.DECIMAL.getValor()) {
                where.append(inicial + parametros.get(i).getNomeCampo() + "= " + parametros.get(i).getValorCampo() + " ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.GERACODIGO.getValor()) {
                where.append(inicial + parametros.get(i).getNomeCampo() + "= " + parametros.get(i).getValorCampo() + " ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.DATETIME.getValor()) {
                where.append(inicial + parametros.get(i).getNomeCampo() + "= '" + TrataData.usdata(parametros.get(i).getValorCampo(), false) + "' ");
            }
            if (parametros.get(i).getTipocampo() == TipoCampoEnum.DATE.getValor()) {
                where.append(inicial + parametros.get(i).getNomeCampo() + "= '" + TrataData.usdata(parametros.get(i).getValorCampo(), true) + "' ");
            }
            if (parametros.get(i).getTipocampo() != TipoCampoEnum.BETWEEN.getValor()) continue;
            where.append("(" + inicial + parametros.get(i).getNomeCampo() + ">= '" + parametros.get(i).getValorCampo() + " 00:00:00' AND " + inicial + parametros.get(i).getNomeCampo() + " <= '" + parametros.get(i).getValorCampo() + " 23:59:59') ");
        }
        return where.toString();
    }

    private static String geraCodigo(String tabela, String campo, String inciais) throws ErroException, IOException {
        int codigo = 1;
        String xsql = "SELECT max(" + inciais + campo + ")+1 as codigo FROM " + tabela;
        Conexao banco = Conexao.getInstance();
        banco.setDatabase(dataBase);
        banco.consulta(xsql);
        ResultSet rs = banco.getRs();
        try {
            while (rs.next()) {
                codigo = rs.getInt("codigo");
                if (codigo > 0) continue;
                codigo = 1;
            }
        }
        catch (Exception e) {
            codigo = 1;
        }
        banco.fecharconexao();
        return Integer.toString(codigo);
    }

    private static String[] brokenString(String texto) {
        return texto.trim().split(" ");
    }

    public static int getCodGerado() {
        return codGerado;
    }

    public static void setCodGerado(int aCodGerado) {
        codGerado = aCodGerado;
    }

    static {
        dataBase = "";
    }
}

