/*
 * Decompiled with CFR 0.152.
 */
package br.com.benevix.weblib.persistencia;

import br.com.benevix.weblib.enuns.AmbienteSistemaEnum;
import br.com.benevix.weblib.sistema.ConfiguracaoBanco;
import br.com.benevix.weblib.sistema.ErroException;
import br.com.benevix.weblib.utilidades.Log;
import br.com.benevix.weblib.utilidades.ProcessaJSon;
import br.com.benevix.weblib.utilidades.UtilSistema;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Conexao {
    private String database = "";
    private static Connection conn = null;
    private ResultSet rs = null;
    private Statement smt = null;
    private static ProcessaJSon processaJson = new ProcessaJSon();
    private static volatile Conexao conexao = null;
    private static final String JDBC_SQLSERVER = "jdbc:sqlserver://";
    private static final String JDBC_COMPLEMENTO = ";databaseName=";
    private static final String ARQSISTEMA = "sistema.json";

    private Conexao() {
    }

    private static Connection getConexao() throws ErroException, IOException {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            String ambiente = UtilSistema.pegaAmbiente();
            ConfiguracaoBanco configuracaoBanco = new ConfiguracaoBanco();
            configuracaoBanco = processaJson.toOBJ(processaJson.lerArquivoResource(ARQSISTEMA), configuracaoBanco);
            if (ambiente.equals(AmbienteSistemaEnum.LOCAL.toString())) {
                Conexao.setConn(DriverManager.getConnection(JDBC_SQLSERVER + configuracaoBanco.getTeste().getIp() + ":" + configuracaoBanco.getTeste().getPorta() + JDBC_COMPLEMENTO + conexao.getDatabase(), configuracaoBanco.getTeste().getUsuario(), configuracaoBanco.getTeste().getPassword()));
            }
            if (ambiente.equals(AmbienteSistemaEnum.TESTE.toString())) {
                Conexao.setConn(DriverManager.getConnection(JDBC_SQLSERVER + configuracaoBanco.getTeste().getIp() + ":" + configuracaoBanco.getTeste().getPorta() + JDBC_COMPLEMENTO + conexao.getDatabase(), configuracaoBanco.getTeste().getUsuario(), configuracaoBanco.getTeste().getPassword()));
            }
            if (ambiente.equals(AmbienteSistemaEnum.HOMOLOGACAO.toString())) {
                Conexao.setConn(DriverManager.getConnection(JDBC_SQLSERVER + configuracaoBanco.getHomologacao().getIp() + ":" + configuracaoBanco.getHomologacao().getPorta() + JDBC_COMPLEMENTO + conexao.getDatabase(), configuracaoBanco.getHomologacao().getUsuario(), configuracaoBanco.getHomologacao().getPassword()));
            }
            if (ambiente.equals(AmbienteSistemaEnum.PRODUCAO.toString())) {
                Conexao.setConn(DriverManager.getConnection(JDBC_SQLSERVER + configuracaoBanco.getProducao().getIp() + ":" + configuracaoBanco.getProducao().getPorta() + JDBC_COMPLEMENTO + conexao.getDatabase(), configuracaoBanco.getProducao().getUsuario(), configuracaoBanco.getProducao().getPassword()));
            }
            return Conexao.getConn();
        }
        catch (ClassNotFoundException e) {
            Log.registraLog(Conexao.class, "Erro ao carregar o drive do banco " + e.getMessage(), e);
            throw new ErroException("Erro ao carregar o drive do banco " + e.getMessage());
        }
        catch (SQLException e) {
            Log.registraLog(Conexao.class, "Erro ao conectar no banco " + e.getMessage(), e);
            throw new ErroException("Erro ao conectar no banco " + e.getMessage());
        }
    }

    public void consulta(String sql) throws ErroException, IOException {
        try {
            Conexao.setConn(Conexao.getConexao());
            this.setSmt(Conexao.getConn().createStatement());
            this.setRs(this.getSmt().executeQuery(sql));
        }
        catch (SQLException e) {
            Log.registraLog(Conexao.class, "MENS : um erro foi gerado " + e.getMessage(), e);
            throw new ErroException("MENS : um erro foi gerado " + e.getMessage());
        }
    }

    public void executa(String sql) throws ErroException, SQLException, IOException {
        try {
            Conexao.setConn(Conexao.getConexao());
            this.setSmt(Conexao.getConn().createStatement());
            Conexao.getConn().setAutoCommit(false);
            this.getSmt().executeUpdate(sql);
            Conexao.getConn().commit();
        }
        catch (SQLException e) {
            Conexao.getConn().rollback();
            Log.registraLog(Conexao.class, "Erro ao executar query " + e.getMessage(), e);
            throw new ErroException("Erro ao executar query " + e.getMessage());
        }
    }

    public void fecharconexao() throws ErroException {
        try {
            this.getSmt().close();
            Conexao.getConn().close();
        }
        catch (SQLException e) {
            Log.registraLog(Conexao.class, "MENS : Erro ao fechar a conex\u00e3o " + e.getMessage(), e);
            throw new ErroException("MENS : Erro ao fechar a conex\u00e3o " + e.getMessage());
        }
    }

    public static Conexao getInstance() {
        conexao = new Conexao();
        return conexao;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public ResultSet getRs() {
        return this.rs;
    }

    public void setRs(ResultSet rs) {
        this.rs = rs;
    }

    public Statement getSmt() {
        return this.smt;
    }

    public void setSmt(Statement smt) {
        this.smt = smt;
    }

    public static Connection getConn() {
        return conn;
    }

    public static void setConn(Connection aConn) {
        conn = aConn;
    }
}

